/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.config.Configuration;
import jace.config.DynamicSelection;
import jace.config.StringComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataListener;

class DynamicSelectComponent
extends JComboBox
implements ActionListener {
    Configuration.ConfigNode node;
    String fieldName;
    Serializable currentValue;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.node.setFieldValue(this.fieldName, this.currentValue);
    }

    public void synchronizeValue() {
        try {
            Serializable value = this.node.getFieldValue(this.fieldName);
            if (value == null) {
                this.getModel().setSelectedItem(null);
                this.setSelectedItem(this.getModel().getSelectedItem());
            } else {
                this.getModel().setSelectedItem(value);
                this.setSelectedItem(this.getModel().getSelectedItem());
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StringComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DynamicSelectComponent(Configuration.ConfigNode node, String fieldName) {
        try {
            DynamicSelection sel;
            this.node = node;
            this.fieldName = fieldName;
            try {
                sel = (DynamicSelection)node.subject.getClass().getField(fieldName).get(node.subject);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(DynamicSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
                System.err.print("Couldn't get selections for field " + fieldName);
                return;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(DynamicSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
                System.err.print("Couldn't get selections for field " + fieldName);
                return;
            }
            catch (NoSuchFieldException ex) {
                Logger.getLogger(DynamicSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
                System.err.print("Couldn't get selections for field " + fieldName);
                return;
            }
            catch (SecurityException ex) {
                Logger.getLogger(DynamicSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
                System.err.print("Couldn't get selections for field " + fieldName);
                return;
            }
            this.currentValue = node.getFieldValue(fieldName);
            final LinkedHashMap selections = sel.getSelections();
            this.addActionListener(this);
            this.setModel(new ComboBoxModel(){
                Map.Entry value;

                @Override
                public void setSelectedItem(Object anItem) {
                    if (anItem != null && anItem instanceof Map.Entry) {
                        this.value = (Map.Entry)anItem;
                        DynamicSelectComponent.this.currentValue = (Serializable)((Map.Entry)anItem).getKey();
                    } else {
                        for (Map.Entry entry : selections.entrySet()) {
                            if (entry.getValue().equals(anItem)) {
                                this.value = entry;
                                DynamicSelectComponent.this.currentValue = (Serializable)entry.getKey();
                            }
                            if (entry.getKey() == null && anItem == null) {
                                this.value = entry;
                                DynamicSelectComponent.this.currentValue = (Serializable)entry.getKey();
                            }
                            if (entry.getKey() == null || !entry.equals(anItem)) continue;
                            this.value = entry;
                            DynamicSelectComponent.this.currentValue = (Serializable)entry.getKey();
                        }
                    }
                }

                @Override
                public Object getSelectedItem() {
                    return selections.get(DynamicSelectComponent.this.currentValue);
                }

                @Override
                public int getSize() {
                    return selections.size();
                }

                @Override
                public Object getElementAt(int index) {
                    for (Map.Entry entry : selections.entrySet()) {
                        if (index == 0) {
                            return entry.getValue();
                        }
                        --index;
                    }
                    return null;
                }

                @Override
                public void addListDataListener(ListDataListener l) {
                }

                @Override
                public void removeListDataListener(ListDataListener l) {
                }
            });
            this.synchronizeValue();
        }
        catch (SecurityException ex) {
            Logger.getLogger(DynamicSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

